#ifndef __ANAGRAMSERVER_H__
#define __ANAGRAMSERVER_H__
/*------------------------------------------------------------------------
  **** BEGIN LICENSE BLOCK ****
  Version: MPL 1.1/GPL 2.0/LGPL 2.1
  Copyright(c) 2004-2010 Created by Eric Fredericksen (www.pttpsystems.com)
  All Rights Reserved.

  This program are subject to the Mozilla Public License Version
  1.1 (the "License"); you may not use this file except in compliance with
  the License. You may obtain a copy of the License at
  http://www.mozilla.org/MPL/

  This program is free software. Software distributed under the License
  is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND,
  either express or implied. See the License for the specific language
  governing rights and limitations under the License.

  Alternatively, the contents of this file may be used under the terms of
  either the GNU General Public License Version 2 or later (the "GPL"), or
  the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
  in which case the provisions of the GPL or the LGPL are applicable instead
  of those above. If you wish to allow use of your version of this file only
  under the terms of either the GPL or the LGPL, and not to allow others to
  use your version of this file under the terms of the MPL, indicate your
  decision by deleting the provisions above and replace them with the notice
  and other provisions required by the GPL or the LGPL. If you do not delete
  the provisions above, a recipient may use your version of this file under
  the terms of any one of the MPL, the GPL or the LGPL.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59 Temple
  Place, Suite 330, Boston, MA 02111-1307 USA
  **** END LICENSE BLOCK ****
------------------------------------------------------------------------*/

// our base classes
#include "Anagrams.h"
#include "ThreadTools.h"
#include "ServerTools.h"

/*==================================================
	create an anagram server specific task through 
	derivation from the generic threading class
==================================================*/
class CAnagramThread : public CTaskThread
{
public:

	enum
	{
		DEFAULT_SHUTDOWN_WAIT_ms	= 20,
		DEFAULT_SOCKET_TIMEOUT_ms	= 30000,
		// as defined by our challenge problem
		MAX_REQUEST_READ			= 100,
		MAX_REQUEST_BUF				= MAX_REQUEST_READ+1
	};

protected:

	// use this to read and write
	SOCKET m_oMySocket;

	char m_facRequestStringBuffer[MAX_REQUEST_BUF];

	// for memory conservation the worker threads only use one dictionary
	static CAnagramDictionary * m_poAnagramDictionary;

	// read the string into a buffer, null terminate, check for errors
	bool ReadRequestString(void);
	void ProcessRequestString(void);


public:

	void AssignThread(SOCKET _oMySocket);

	// override this for doing our work
	virtual DWORD VirtualCallbackFunction(void);

};



//==================================================
//
//==================================================
class CAnagramServer : public CServer
{
public:

	enum
	{
		DEFAULT_WORKTHREAD_COUNT = 5
	};

protected:

	CAnagramThread m_faoWorkThreads[DEFAULT_WORKTHREAD_COUNT];

	bool m_bInitSuccess;

public:

	bool InitSuccess(void);

	CAnagramServer(void);
	virtual ~CAnagramServer();

	virtual void DispatchConnection(SOCKET _sWorkSocket);

};

#endif //__ANAGRAMSERVER_H__
